% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_calibration_functions.R
\name{log_lik_par}
\alias{log_lik_par}
\title{Parallel evaluation of log-likelihood function for a sets of parameters}
\usage{
log_lik_par(v_params, l_params_all = l_params_all_calib, ...)
}
\arguments{
\item{v_params}{Vector (or matrix) of model parameters.}

\item{l_params_all}{List with all parameters of the decision model.}
}
\value{
A scalar (or vector) with log-likelihood values.
}
\description{
\code{log_lik_par} computes a log-likelihood value for one (or multiple)
parameter set(s) using parallel computation.
}
\examples{
\dontrun{
v_param_names  <- c("r_DieMets",
                    "r_RecurCDX2pos",
                    "hr_RecurCDX2neg",
                    "p_Mets")
n_param        <- length(v_param_names)
v_lb <- c(r_DieMets       = 0.037, 
          r_RecurCDX2pos  = 0.001,
          hr_RecurCDX2neg = 1.58, 
          p_Mets          = 0.9))  # lower bound
v_ub <- c(r_DieMets       = -log(1-(1-0.03))/60, 
          r_RecurCDX2pos  = 0.03,
          hr_RecurCDX2neg = 4.72, 
          p_Mets          = 0.99) # upper bound
v_target_names <- c("DFS", "OS", "DSS")
n_target       <- length(v_target_names)
log_lik_par(v_params = sample.prior(n_samp = 2))
}
}
