% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_model_inputs_functions.R
\name{load_params_init}
\alias{load_params_init}
\title{Base-case initial parameter set}
\usage{
load_params_init(
  n_age_init = 65,
  n_age_max = 100,
  n_cycles_year = 12,
  d_c = 0.03,
  d_e = 0.03,
  index_pce = 0.018,
  p_CDX2neg = 0.0717488789237668,
  p_Mets = 0.980840626,
  r_DieMets = 0.03870286,
  r_RecurCDX2pos = 0.003328773,
  hr_RecurCDX2neg = 3.601069078,
  hr_Recurr_CDXneg_Rx = 0.82,
  hr_Recurr_CDXpos_Rx = 1,
  c_Chemo = 1576,
  c_ChemoAdmin = 315,
  c_CRCStg2_init = (32039 - (1391 + 315)),
  c_CRCStg2_cont = 1722,
  c_CRCStg4_cont = 7629,
  ic_DeathCRCStg2 = 41500,
  ic_DeathOCStg2 = 8969,
  c_Test = 112,
  u_Stg2 = 0.74,
  u_Stg2Chemo = 0.67,
  u_Mets = 0.25
)
}
\arguments{
\item{n_age_init}{Initial age of the cohort.}

\item{n_age_max}{Oldest age of the cohort.}

\item{n_cycles_year}{Number of cycles per year}

\item{d_c}{Discount factor for costs}

\item{d_e}{Discount factor for effectiveness}

\item{index_pce}{Personal consumption expenditures (PCE) price index}

\item{p_CDX2neg}{Proportion of CDX2-negative patients}

\item{p_Mets}{Proportion of recurrence being metastatic}

\item{r_DieMets}{Cancer mortality rate}

\item{r_RecurCDX2pos}{Rate of recurrence in CDX2 positive patients}

\item{hr_RecurCDX2neg}{Hazard ratio of recurrence in CDX2 negative vs
positive patients}

\item{hr_Recurr_CDXneg_Rx}{Hazard ratio for disease recurrence among patients
with CDX2-negative under chemotherapy versus CDX2-negative patients without
chemotherapy.}

\item{hr_Recurr_CDXpos_Rx}{Hazard ratio for disease recurrence among patients
with CDX2-positive under chemotherapy versus CDX2-positive patients without
chemotherapy.}

\item{c_Chemo}{Cost of chemotherapy}

\item{c_ChemoAdmin}{Cost of chemotherapy administration}

\item{c_CRCStg2_init}{Initial costs in CRC Stage II (minus chemo and
chemotherapy administration)}

\item{c_CRCStg2_cont}{Continuing costs in CRC Stage II}

\item{c_CRCStg4_cont}{Continuing costs in CRC Stage IV}

\item{ic_DeathCRCStg2}{Increase in cost when dying from cancer while in
Stage II}

\item{ic_DeathOCStg2}{Increase in cost when dying from Other Causes (OC)
while in Stage II}

\item{c_Test}{Cost of IHC staining}

\item{u_Stg2}{Utility for CRC Stage II patients}

\item{u_Stg2Chemo}{Utility for CRC Stage II patients under chemotherapy}

\item{u_Mets}{Utility for metastatic recurrence state}
}
\value{
List of all parameters
}
\description{
\code{load_params_init} generates the initial values of the CDX2 CEA model
}
