% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05b_deterministic_analysis_functions.R
\name{ce_model}
\alias{ce_model}
\title{Cost-effectiveness model}
\usage{
ce_model(
  l_params_all,
  p_CDX2neg_init = NULL,
  Trt = FALSE,
  err_stop = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{l_params_all}{List with all parameters of cost-effectiveness model}

\item{p_CDX2neg_init}{Initial proportion of CDX2-negative patients. Default
is NULL and will take the value of \code{p_CDX2neg} defined in
\code{load_all_params()}}

\item{Trt}{Treatment variable (default is FALSE)}

\item{err_stop}{Logical variable to stop model run if set up as TRUE. Default
= FALSE.}

\item{verbose}{Logical variable to indicate print out of messages. Default
= FALSE}
}
\value{
The transition probability array, the cohort trace matrix, the transition
dynamics array, and the undiscounted and discounted life years (LYs),
quality-adjusted life years (QALYs) and costs
}
\description{
\code{ce_model} implements the cost-effectiveness model used.
}
