% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/value_of_hope.R
\name{value_of_hope}
\alias{value_of_hope}
\title{Value of hope}
\usage{
value_of_hope(econmod, comparator, crra = 0.39, dr = 0.03)
}
\arguments{
\item{econmod}{An economic model of class \code{"IndivCtstm"}. Disease progression
must have been previously simulated (i.e., \code{$disprog_} cannot be \code{NULL}.)}

\item{comparator}{The \code{strategy_id} from \code{econmod} to use as the comparator.}

\item{crra}{Constant relative risk aversion parameter.}

\item{dr}{Discount rate.}
}
\value{
A \code{data.table} with columns:
\describe{
\item{strategy_id}{The treatment strategy ID.}
\item{comparator}{Equal to 1 if the treatment strategy is the comparator and 0 otherwise.}
\item{qalys}{Mean QALYs.}
\item{iqalys}{Incremental mean QALYs; that is, mean QALYs relative to the comparator.}
\item{ce}{The certainty equivalent.}
\item{voh}{The 'value of hope'. See 'Details'.}
}
}
\description{
Compute the quality-adjusted life-years (QALYs) that a patient would need to obtain
to be indifferent between treatment sequences relative to a reference treatment 
sequence (i.e., compute the "certainty equivalent"), give differences in the
distribution of QALYs.
}
\details{
The value of hope is the difference between the certainty equivalent and 
differences in mean QALYs between a given treatment strategy and a comparator. That is, 
if \eqn{\alpha} is the certainty equivalent, then the value of hope for treatment strategy
2 relative to treatment strategy 1 is
\deqn{\alpha - (E[qalys_2] - E[qalys_1])}.
}
\seealso{
See the example in the \href{https://innovationvalueinitiative.github.io/IVI-NSCLC/articles/tutorial.html}{tutorial}.
}
