% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcda.R
\name{txattr_performance}
\alias{txattr_performance}
\title{Treatment attribute performance}
\usage{
txattr_performance(struct, patients, econmod,
  treatments = iviNSCLC::treatments)
}
\arguments{
\item{struct}{A \code{\link{model_structure}} object.}

\item{patients}{A data table returned from \code{\link{create_patients}}.}

\item{econmod}{An economic model of class \code{"IndivCtstm"}. Disease progression
must have been previously simulated (i.e., \code{$disprog_} cannot be \code{NULL}.)}

\item{treatments}{An object in the same format as \code{\link{treatments}}.}
}
\value{
A \code{data.table} with four columns:
\describe{
\item{sample}{\code{sample} from \code{econmod$disprog_}}
\item{strategy_id}{\code{strategy_id} from \code{econmod$disprog_}}
\item{route}{Route of administration, weighted by the time each
simulated patient uses each therapy in a treatment sequence. Oral administration
is given a value of 1 and intravenous administration is given a value of 0.}
\item{yrs_since_approval}{Years since FDA approval, weighted by the time each
simulated patient uses each therapy in a treatment sequence.}
}
}
\description{
Compute performance for multi criteria decision analysis (MCDA)
 criteria related to treatment attributes.
}
\seealso{
See the example in the \href{https://innovationvalueinitiative.github.io/IVI-NSCLC/articles/tutorial.html}{tutorial}.
}
