% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/txseq.R
\name{tx_2LP}
\alias{tx_2LP}
\title{Second line plus treatment options}
\usage{
tx_2LP(second)
}
\arguments{
\item{second}{A vector of possible treatments after second line. Must be of length 2 with the 
first element corresponding to use with a T790M mutation and the second election corresponding 
to treatment without a T790M mutation.}
}
\value{
A list of two elements:
\describe{
\item{pos}{Possible treatments with a T790M mutation.}
\item{neg}{Possible treatments without a T790M mutation.}
}
}
\description{
Treatment after second line for EGFR+ NSCLC patients conditional on possible second line treatments.
}
\examples{
first <- tx_1L()[3]
print(first)
second_opts <- tx_2L(first)
print(second_opts)
tx_2LP(c(second_opts$pos[1], second_opts$neg[1]))
}
