% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{params_utility}
\alias{params_utility}
\title{Utility parameters}
\format{A list containing the following elements:
\itemize{
\item{state_utility}{ Utility estimates by health state.}
\item{as_disutility}{ Disutility by health state.}
}}
\usage{
params_utility
}
\description{
Utility estimates by health state and disutilities by adverse event.
}
\section{State utility}{

The \code{state_utility} element is a data table with the following columns:
\describe{
\item{state_name}{Name of the health state.}
\item{mean}{Mean utility.}
\item{se}{Standard error of utility.}
\item{ref}{BibTeX reference for estimate.}
}
}

\section{Adverse event disutilities}{

The \code{as_disutility} element is a data table with the following columns:
\describe{
\item{ae_name}{Name of the adverse event.}
\item{ae_abb}{Abbreviation for the adverse event.}
\item{mean}{Mean disutility.}
\item{se}{Standard error of disutility.}
\item{ref}{BibTeX reference for estimate.}
}
}

\examples{
print(params_utility)
}
\keyword{datasets}
