% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-setup.R
\name{create_trans_mat}
\alias{create_trans_mat}
\title{Create transition matrix}
\usage{
create_trans_mat(object)
}
\arguments{
\item{object}{A \code{\link{model_structure}} object.}
}
\value{
A transition matrix of the same format as in the \link[mstate]{mstate} 
package.
}
\description{
Create a transition matrix describing patient transitions between 
health states.
}
\examples{
txseq1 <- txseq(first = "erlotinib",
               second = c("osimertinib", "PBDC"),
               second_plus = c("PBDC + bevacizumab", "PBDC + bevacizumab"))
txseq2 <- txseq(first = "gefitinib",
               second = c("osimertinib", "PBDC"),
               second_plus = c("PBDC + bevacizumab", "PBDC + bevacizumab")) 
txseqs <- txseq_list(seq1 = txseq1, seq2 = txseq2) 

struct1 <- model_structure(txseqs, n_states = "four")
create_trans_mat(struct1)
 
struct2 <- model_structure(txseqs, n_states = "three")
create_trans_mat(struct2)
 
txseqs <- txseq_list(seq1 = txseq1, seq2 = txseq2, 
                     start_line = "second", mutation = "positive")
struct3 <- model_structure(txseqs, n_states = "three")
create_trans_mat(struct3)
}
