% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/costmods.R
\name{create_costmods}
\alias{create_costmods}
\title{Create cost models}
\usage{
create_costmods(n = 100, struct, patients, ae_probs,
  params_costs_tx = iviNSCLC::params_costs_tx,
  params_costs_op = iviNSCLC::params_costs_op,
  params_costs_inpt = iviNSCLC::params_costs_inpt,
  params_costs_ae = iviNSCLC::params_costs_ae)
}
\arguments{
\item{n}{The number of random observations of the parameters to draw.}

\item{struct}{A \code{\link{model_structure}} object.}

\item{patients}{A data table returned from \code{\link{create_patients}}.}

\item{ae_probs}{An "ae_probs" object as returned by \code{\link{ae_probs}}.}

\item{params_costs_tx}{Parameter estimates for treatment costs (i.e.,
acquisition and administration costs) in the same format as 
\code{\link{params_costs_tx}}.}

\item{params_costs_op}{Parameter estimates for outpatient medical costs
in the same format as \code{\link{params_costs_op}}.}

\item{params_costs_inpt}{Parameter estimates for inpatient medical costs
in the same format as \code{\link{params_costs_inpt}}.}

\item{params_costs_ae}{Parameter estimates for adverse event costs
in the same format as \code{\link{params_costs_ae}}.}
}
\value{
A list of objects of class "StateVals" from the 
\href{https://hesim-dev.github.io/hesim/}{hesim} package.
}
\description{
Create a cost model for four cost categories: (i) treatment costs (i.e., drug
acquisition and administration costs), (ii) inpatient medical costs, 
(iii) outpatient medical costs, and (iv) costs due to adverse events.
}
\examples{
# Treatment sequences
txseq1 <- txseq(first = "erlotinib",
                second = c("osimertinib", "PBDC"),
                second_plus = c("PBDC + bevacizumab", "PBDC + bevacizumab"))
txseq2 <- txseq(first = "gefitinib",
                second = c("osimertinib", "PBDC"),
                second_plus = c("PBDC + bevacizumab", "PBDC + bevacizumab"))
txseqs <- txseq_list(seq1 = txseq1, seq2 = txseq2)

# Patient population
pats <- create_patients(n = 2)

# Model structure
struct <- model_structure(txseqs, dist = "weibull")

## Cost models
n_samples <- 2
ae_probs <- ae_probs(n = n_samples, struct = struct)
costmods <- create_costmods(n = 2, struct = struct, patients = pats,
                            ae_probs = ae_probs)
}
