% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adverse-events.R
\name{ae_probs}
\alias{ae_probs}
\title{Adverse event probabilities}
\usage{
ae_probs(n, struct, params_ae = iviNSCLC::params_ae_nma)
}
\arguments{
\item{n}{The number of random observations of the parameters to draw.}

\item{struct}{A \code{\link{model_structure}} object.}

\item{params_ae}{Parameter estimates of the probabilities of adverse 
events in the same format as \code{\link{params_ae_nma}}.}
}
\value{
A list of matrices where each matrix corresponds to a type of adverse
event. Rows of each matrix are posterior samples of the parameters and columns
are treatment strategies. The list is an object of class "ae_probs" with an
attribute "tx_abb" denoting the treatment used to estimate adverse events for
 each treatment sequence.
}
\description{
Obtain adverse event probabilities for treatment sequences given existing 
probabilities by treatment from a network meta-analysis.
}
\examples{
txseq1 <- txseq(first = "erlotinib",
                second = c("osimertinib", "PBDC"),
                second_plus = c("PBDC + bevacizumab", "PBDC + bevacizumab"))
txseq2 <- txseq(first = "gefitinib",
                second = c("osimertinib", "PBDC"),
                second_plus = c("PBDC + bevacizumab", "PBDC + bevacizumab"))
txseqs <- txseq_list(seq1 = txseq1, seq2 = txseq2) 
struct <- model_structure(txseqs)
ae_probs <- ae_probs(n = 3, struct = struct)
print(ae_probs[1:3])
tidy_ae_probs <- tidy(ae_probs)
head(tidy_ae_probs)
}
